<?php 
    /**
    *
    * copyright (c) 2013-2021 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    class VisualizzatoreComunicazioni extends VisualizzatoreComponente {
        private $stringaGruppiUtente;
        
        function generaContenuto($dati) {
            if($dati["tipo"]=="ticket") {
                $queryNumeroArticoli = "SELECT COUNT(*) FROM geecAd_comunicazioni WHERE tipo LIKE '{$dati["tipo"]}' AND idUtente={$_SESSION["geecomUser_id"]}";
            }
            else if($dati["tipo"]=="comunicazione") {
                $this->stringaGruppiUtente = " AND c.id IN ( SELECT idComunicazione FROM geecAd_gruppiDestinatari WHERE idGruppoDestinatario = 0 ";
                foreach($_SESSION["geecomUser_gruppiUtente"] as $gruppo) {
                    $this->stringaGruppiUtente .= "OR idGruppoDestinatario = $gruppo ";
                }
                $this->stringaGruppiUtente .= ")";
                
                $queryNumeroArticoli = "SELECT COUNT(*) FROM geecAd_comunicazioni AS c WHERE tipo LIKE '{$dati["tipo"]}' {$this->stringaGruppiUtente}";
            }
            else {
                $queryNumeroArticoli = "SELECT COUNT(*) FROM geecAd_comunicazioni WHERE tipo LIKE '{$dati["tipo"]}'";
            }
            $risNumArticoli = parent::getDb()->eseguiQueryLettura($queryNumeroArticoli);
            $numArticoli = $risNumArticoli->fetch_array(MYSQLI_NUM);

            if($dati["tipo"]=="ticket") {
                $queryComunicazioni = "SELECT * FROM geecAd_comunicazioni WHERE tipo LIKE '{$dati["tipo"]}' AND idUtente={$_SESSION["geecomUser_id"]} ORDER BY id DESC";
            }
            else if($dati["tipo"]=="comunicazione") {
                $queryComunicazioni = "SELECT * FROM geecAd_comunicazioni AS c WHERE tipo LIKE '{$dati["tipo"]}' {$this->stringaGruppiUtente}";
            }
            else {
                $queryComunicazioni = "SELECT * FROM geecAd_comunicazioni WHERE tipo LIKE '{$dati["tipo"]}'";
            }
            $risComunicazioni = parent::getDb()->eseguiQueryLettura($queryComunicazioni);
            
            if($risComunicazioni->num_rows==0) {
                if($dati["tipo"]=="segnalazione") {
                    $tipoComunicazione = "segnalazioni";
                }
                else if($dati["tipo"]=="comunicazione") {
                    $tipoComunicazione = "comunicazioni";
                }
                else {
                    $tipoComunicazione = $dati["tipo"];
                }
                echo("<h3>Non ci sono {$tipoComunicazione} al momento</h3>");
            }
            
            while($comunicazione = $risComunicazioni->fetch_assoc()) {
                if($dati["tipo"]=="ticket") {
                    $this->stampaTicket($comunicazione);
                }
                else {
                    $this->stampaComunicazione($comunicazione);
                }
            }
        }
                
        function stampaComunicazione($comunicazione) {
            $data = date("d/m/Y",strtotime($comunicazione["dataCreazione"]));
            echo "<div class=\"card\">
                <div class=\"card-header\">
                    <h5 class=\"mb-1\">{$comunicazione["oggetto"]}</h5>
                </div>
                <div class=\"card-body\">
                    <i class=\"far fa-calendar-alt mr-2 d-inline-block\"></i><h6 class=\"text-muted d-inline-block\">$data</h6>
                    {$comunicazione["testo"]}
                </div>
            </div>";
        }
        
        function stampaTicket($ticket) {
            $queryUltimaRisposta = "SELECT * FROM geecAd_risposteTicket WHERE idTicket={$ticket["id"]} ORDER BY dataCreazione DESC LIMIT 1";
            $risUltimaRisposta   = parent::getDb()->eseguiQueryLettura($queryUltimaRisposta);
            if($risUltimaRisposta->num_rows>0) {
                $ultimaRisposta = $risUltimaRisposta->fetch_assoc();
                $dataRisposta = date("d/m/Y",strtotime($ultimaRisposta["dataCreazione"]));
                $oraRisposta  = date("H:i",strtotime($ultimaRisposta["dataCreazione"]));
            }
            else {
                $ultimaRisposta = null;
            }
            
            $data = date("d/m/Y",strtotime($ticket["dataCreazione"]));
            $ora  = date("H:i",strtotime($ticket["dataCreazione"]));
            if($ticket["priorita"]=="alta") {
                $classePriorita="danger";
            }
            else if($ticket["priorita"]=="media") {
                $classePriorita="warning";
            }
            else {
                $classePriorita="info";
            }
            $classeStato = ($ticket["stato"]!="chiuso") ? "warning" : "info";
            echo"<div class=\"card p-4 box-shadow-lite ticket\">
                    <div class=\"d-flex justify-content-between align-items-start mb-2\">
                        <small>
                            <strong class=\"d-block\">ID:{$ticket["id"]} - <span class=\"text-$classePriorita\">Priorità ".StampaContenuti::fiammePriorita($ticket["priorita"])."</span></strong>
                            <span>Creato il <strong>$data</strong> <i class=\"far fa-clock\"></i> <strong>$ora</strong></span> 
                            <span class=\"mx-2 d-none d-lg-inline-block\">|</span>
                            <span>";
                            echo(($ultimaRisposta==null) ? "Ancora Nessuna risposta":"Ultima risposta del <strong>$dataRisposta</strong> <i class=\"far fa-clock\"></i> <strong>$oraRisposta</strong>");
                            echo"</span>
                        </small>
                        <span class=\"badge badge-$classeStato d-flex align-items-center px-2\">".ucfirst($ticket["stato"])."</span>
                    </div>
                    <a href=\"dettagliTicket.php?id={$ticket["id"]}\"><h6 class=\"mb-0\">{$ticket["testo"]}</h6> </a>
                </div>";
        }
    }